/*
 *	Filename:	utils.c
 *  Function:	various utility functions
 *	Author:		Paul Elseth
 *            	Copyright (c) 1991, Paul Elseth
 *
 *	Change History:
 *
 *		12/03/91	PBE		created
 */

#ifndef	__UTILS__
#include "utils.h"
#endif
#ifndef	__FOUNDATION__
#include "foundation.h"
#endif
#ifndef	__GLOBALS__
#include "globals.h"
#endif
#ifndef	__QDAUX___
#include <qdaux.h>
#endif
#ifndef	__RESOURCES__
#include <resources.h>
#endif
#ifndef	__orca__
#include <orca.h>
#endif
#ifndef	__OPTIONS__
#include "options.h"
#endif

#pragma noroot


/*
 *  GetPrivateData()
 *		Get a window's private data.
 */
Handle GetPrivateData(WindowPtr wp)
{
	fPrivateDataRec	pDataP;
	short			err;

	pDataP.pCount = 4;
    pDataP.winPtr = (Pointer) wp;

	err = fGetPrivateData(&pDataP);

	return pDataP.Data;
}


/*
 *	LoadAResource()
 *	    Tell the shell to load a resource from the file being edited.
 */
short LoadAResource(short type, long id, Handle *h)
{
	fResDataRec	parms;
    short		err;

	parms.pCount = 3;
	parms.resType = type;
    parms.resID = id;
	
	err = fLoadResource(&parms);

	*h = parms.resData;

	return err;
}


/*	
 *	LoadMyResource()
 *	    Tell the shell to load a resource from my resource fork.
 */
short LoadMyResource(short type, long id, Handle *h)
{		
	fResDataRec	parms;
    short		err;

	parms.pCount = 5;
	parms.resType = type;
    parms.resID = id;
	parms.resFileID = gEdResFile;
	err = fLoadResource(&parms);

	*h = parms.resData;

	return err;
}


/*	
 *	DetachMyResource()
 *	    Tell the shell to detach a resource of mine.
 */
short DetachMyResource(short type, long id)
{
	fResRefRec	parms;

	parms.pCount = 3;
	parms.resType = type;
    parms.resID = id;
	parms.resFileID = gEdResFile;
	return fDetachResource(&parms);
}


/*
 *	GetWindowTitle()
 *		Return the standardized title for an editor window.
 */
short GetWindowTitle(short type, long id, char *buffer)
{
	fResNameRec	parms;

	parms.pCount = 3;
    parms.resType = type;
    parms.resID = id;
    parms.resName = buffer;
    return fGetWindowTitle(&parms);
}


/*
 *	CloseAWindow()
 *	    Closes a foundation window after releasing the data therein.
 */
short CloseAWindow(WindowPtr wp)
{
	fPrivateDataRec	parms;
	short			err;
 
	parms.pCount = 1;
    parms.winPtr = (Ptr) wp;
    err = fRelPrivateData(&parms);

	if (err == 0) {
		CloseWindow(wp);
        err = toolerror();
        }

	return err;
}


/*
 *	WriteAResource()
 *		Tell the shell to write this resource back to it's file.
 */
short WriteAResource(short type, long id)
{
	fResRefRec	parms;
    
	parms.pCount = 2;
    parms.resType = type;
    parms.resID = id;

	return fWriteResource(&parms);
}


/*
 *	ReleaseAResource()
 *		Tell the shell to relase this resource.
 */
short ReleaseAResource(short type, long id)
{
	fResRefRec	parms;

    parms.pCount = 2;
	parms.resType = type;
	parms.resID = id;

    return fReleaseResource(&parms);
}


/*
 *	SysError()
 *	    Report an error to the user.
 */
void SysError(short err)
{
	(void) ErrorWindow(0, nil, err);
}


/*
 *	SelectAction()
 *		Various selector functions.
 */
short SelectAction(short type, long id, ActionType action)
{
	fResDataRec	parms;

	parms.pCount = 4;
    parms.resType = type;
	parms.resID = id;
	parms.resData = 0L;
	parms.special = action;

	return fSelectorRequest(&parms);
}


/*
 *	AddPrivateData()
 *		Add a private data handle to a window.
 */
short AddPrivateData(WindowPtr wp, Handle dataH, short groupSig, short type, long id)
{
	fPrivateDataRec	parms;
 
	parms.pCount = 7;
	parms.winPtr = (Pointer) wp;
	parms.remTaskMask = 0L;
	parms.remSignature = 0L;
	parms.Data = dataH;
	parms.groupSignature = groupSig;
   	parms.resType = type;
	parms.resID = id;
 
  	return fAddPrivateData(&parms);
}


/*
 *	AddPickerMenu()
 *		Add a picker menu to the menu bar.
 */
short AddPickerMenu(short resID)
{
	fResDataRec	parms;

/*	asm {brk 0}	*/
	parms.pCount = 5;
    parms.resType = 0x1000;
    parms.resID = resID;
    parms.resData = nil;
    parms.special = 0;
    parms.resFileID = gEdResFile;

    return fSelectorMenu(&parms);
}


/*
 *	MakePattern()
 *		Make a pattern for this color.
 */
void MakePattern(short color, Pattern pat)
{
	asm {
        lda	color
	    xba
		ora	color
        ldy	#0x001e
loop:	sta	[pat],y
		dey
	    dey
		bpl	loop
		}
}
 

/*
 *	SetMyCursor()
 *		Set the cursor w/o blinking.
 */
void SetMyCursor(Cursor *cp)
{
	if (GetCursorAdr() != cp)
	    SetCursor(cp);
}


/*
 *	SetArrowCursor()
 *
 */
void SetArrowCursor(void)
{
	static Cursor	*arrowCursor = nil;

	if (arrowCursor == nil) {
		InitCursor();
		arrowCursor = GetCursorAdr();
        }
	else
		SetMyCursor(arrowCursor);
}


/*
 *	SetWaitCursor()
 *
 */
void SetWaitCursor(void)
{
	static Cursor	*waitCursor = nil;

	if (waitCursor == nil) {
		WaitCursor();
		waitCursor = GetCursorAdr();
        }
	else
		SetMyCursor(waitCursor);
}
